﻿///
/// 実行時にのみ検出できる種類のエラーを表す例外クラスのヘッダファイル。
///

#if       !defined(INCLUDED_SZ_RUNTIME_EXCEPTION)
#define            INCLUDED_SZ_RUNTIME_EXCEPTION

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

/// <summary>
/// SevenZip++ やアプリケーションが利用する実行時エラーを表す例外クラス。
/// </summary>
class SZ_SPEC RuntimeException : public boost::exception, public std::exception
{
public:
  RuntimeException(const szstring &description);
  virtual ~RuntimeException();

  const szstring &GetDescription() const { return description; }

private:
  const szstring description;
};

/// <summary>
/// RuntimeException に付加するために用いる型で、例外が発生したときに行っていた処理を説明する文字列を保持する。
/// </summary>
typedef boost::error_info<struct tag_task, szstring> task_info;

/// <summary>
/// RuntimeException に付加するために用いる型で、GetLastError が返したエラーコードを保持する。
/// </summary>
typedef boost::error_info<struct tag_last_error, u32> last_error_info;

/// <summary>
/// RuntimeException に付加するために用いる型で、HRESULT を保持する。
/// </summary>
typedef boost::error_info<struct tag_last_error, HRESULT> hresult_info;

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_RUNTIME_EXCEPTION)
